/*
 * Decompiled with CFR 0.152.
 */
package io.github.cat24a.klowenia_tales.util;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.math.Rectangle;
import io.github.cat24a.klowenia_tales.Main;

public class GraphicsUtil {
    public static boolean button(Main game, float x, float y, float width, float height, TextureRegion texture) {
        Rectangle rect = GraphicsUtil.centeredRectangle(x, y, width, height);
        boolean contains = rect.contains(game.touchPos);
        if (contains) {
            game.batch.setColor(0.8f, 0.8f, 1.0f, 1.0f);
        }
        GraphicsUtil.drawCentered(game, texture, x, y, width, height);
        if (contains) {
            game.batch.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        }
        return contains && Gdx.input.justTouched();
    }

    public static Rectangle centeredRectangle(float x, float y, float width, float height) {
        return new Rectangle(x - width / 2.0f, y - height / 2.0f, width, height);
    }

    public static Rectangle centeredSquare(float x, float y, float size) {
        return new Rectangle(x - size / 2.0f, y - size / 2.0f, size, size);
    }

    public static void drawCentered(Main game, TextureRegion texture, float x, float y, float width, float height) {
        game.batch.draw(texture, x - width / 2.0f, y - height / 2.0f, width, height);
    }

    public static void drawCentered(Main game, TextureRegion texture, float x, float y) {
        game.batch.draw(texture, x - (float)(texture.getRegionWidth() / 2), y - (float)(texture.getRegionHeight() / 2));
    }
}

